% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_group.R
\name{predefined_tests}
\alias{predefined_tests}
\alias{exact_match}
\alias{range_match}
\alias{range_match_legacy}
\title{User defined tests}
\usage{
exact_match(x, y)

range_match(x, y, range = 10)

range_match_legacy(x, y)
}
\arguments{
\item{x}{Every value of an attribute to compare in \bold{\code{\link{links}}}.}

\item{y}{One value to which is compared against all other values of the same attribute (\code{x})}

\item{range}{Difference between \code{y} and \code{x}.}
}
\description{
A collection of predefined logical tests for \bold{\code{\link{sub_criteria}}}
}
\examples{
library(diyar)

# `exact_match` - test that `x` is equal to `y`
exact_match(x = 1, y = "1")
exact_match(x = 1, y = 1)

# `range_match` - test that `y` is between `x` and `x + range`
range_match(x = 10, y = 16, range = 6)
range_match(x = 16, y = 10, range = 6)

# `range_match_legacy` - test that `x` (10) is within `y` (16 - 10)
x_nl <- number_line(10, 16, gid = 10)
y_nl <- number_line(16, 10)

range_match_legacy(x = x_nl, y = y_nl)

}
