% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{dm_paste}
\alias{dm_paste}
\title{Create R code for a dm object}
\usage{
dm_paste(dm, select = FALSE, tab_width = 2)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{select}{Boolean, default \code{FALSE}. If \code{TRUE} will try to produce code for reducing to necessary columns.}

\item{tab_width}{Indentation width for code from the second line onwards}
}
\value{
Code for producing the given \code{dm}.
}
\description{
\code{dm_paste()} takes an existing \code{dm} and emits the code necessary for its creation.
}
\details{
At the very least (if no keys exist in the given \code{\link{dm}}) a \code{dm()} statement is produced that -- when executed --
produces the same \code{dm}. In addition, the code for setting the existing primary keys as well as the relations between the
tables is produced. If \code{select = TRUE}, statements are included to select the respective columns of each table of the \code{dm} (useful if
only a subset of the columns of the original tables is used for the \code{dm}).

Mind, that it is assumed, that the tables of the existing \code{dm} are available in the global environment under their names
within the \code{dm}.
}
\examples{
dm_nycflights13() \%>\%
  dm_paste()

dm_nycflights13() \%>\%
  dm_paste(select = TRUE)
}
