% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examine-cardinalities.R
\name{dm_examine_cardinalities}
\alias{dm_examine_cardinalities}
\title{Learn about your data model}
\usage{
dm_examine_cardinalities(dm, progress = NA)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{progress}{Whether to display a progress bar, if \code{NA} (the default)
hide in non-interactive mode, show in interactive mode. Requires the
'progress' package.}
}
\value{
A tibble with the following columns:
\describe{
\item{\code{child_table}}{child table,}
\item{\code{child_fk_cols}}{foreign key column(s) in child table as list of character vectors,}
\item{\code{parent_table}}{parent table,}
\item{\code{parent_key_cols}}{key column(s) in parent table as list of character vectors,}
\item{\code{cardinality}}{the nature of cardinality along the foreign key.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function returns a tibble with information about
the cardinality of the FK constraints.
The printing for this object is special, use \code{\link[=as_tibble]{as_tibble()}}
to print as a regular tibble.
}
\details{
Uses \code{\link[=examine_cardinality]{examine_cardinality()}} on each foreign key that is defined in the \code{\link{dm}}.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13() \%>\%
  dm_examine_cardinalities()
\dontshow{\}) # examplesIf}
}
\seealso{
Other cardinality functions: 
\code{\link{examine_cardinality}()}
}
\concept{cardinality functions}
