% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack_join.R
\name{pack_join}
\alias{pack_join}
\alias{pack_join.dm_zoomed}
\title{Pack Join}
\usage{
pack_join(x, y, by = NULL, ..., copy = FALSE, keep = FALSE, name = NULL)

\method{pack_join}{dm_zoomed}(x, y, by = NULL, ..., copy = FALSE, keep = FALSE, name = NULL)
}
\arguments{
\item{x, y}{A pair of data frames or data frame extensions (e.g. a tibble).}

\item{by}{A character vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so that you
can check they're correct; suppress the message by supplying \code{by} explicitly.

To join by different variables on \code{x} and \code{y}, use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a vector with length > 1.
For example, \code{by = c("a", "b")} will match \code{x$a} to \code{y$a} and \code{x$b} to
\code{y$b}. Use a named vector to match different variables in \code{x} and \code{y}.
For example, \code{by = c("a" = "b", "c" = "d")} will match \code{x$a} to \code{y$b} and
\code{x$c} to \code{y$d}.

To perform a cross-join, generating all combinations of \code{x} and \code{y},
use \code{by = character()}.}

\item{...}{Other parameters passed onto methods.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the
output?}

\item{name}{The name of the list column nesting joins create.
If \code{NULL} the name of \code{y} is used.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{pack_join()} returns all rows and columns in \code{x} with a new packed column
that contains all matches from \code{y}.
}
\examples{
df1 <- tibble::tibble(x = 1:3)
df2 <- tibble::tibble(x = c(1, 1, 2), y = c("first", "second", "third"))
pack_join(df1, df2)
}
\seealso{
\code{\link[dplyr:nest_join]{dplyr::nest_join()}}, \code{\link[tidyr:pack]{tidyr::pack()}}
}
