% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-dm.R
\name{dm_set_colors}
\alias{dm_set_colors}
\alias{dm_get_colors}
\alias{dm_get_available_colors}
\title{Color in database diagrams}
\usage{
dm_set_colors(dm, ...)

dm_get_colors(dm)

dm_get_available_colors()
}
\arguments{
\item{dm}{A \code{\link{dm}} object.}

\item{...}{Colors to set in the form \code{color = table}.
Allowed colors are all hex coded colors (quoted) and the color names from \code{dm_get_available_colors()}.
\code{tidyselect} is supported, see \code{\link[dplyr:select]{dplyr::select()}} for details on the semantics.}
}
\value{
For \code{dm_set_colors()}: the updated data model.

For \code{dm_get_colors()}, a named character vector of table names
with the colors in the names.
This allows calling \code{dm_set_colors(!!!dm_get_colors(...))}.
Use \code{\link[tibble:enframe]{tibble::enframe()}} to convert this to a tibble.

For \code{dm_get_available_colors()}, a vector with the available colors.
}
\description{
\code{dm_set_colors()} allows to define the colors that will be used to display the tables of the data model with \code{\link[=dm_draw]{dm_draw()}}.
The colors can either be either specified with hex color codes or using the names of the built-in R colors.
An overview of the colors corresponding to the standard color names can be found at
the bottom of
\url{https://rpubs.com/krlmlr/colors}.

\code{dm_get_colors()} returns the colors defined for a data model.

\code{dm_get_available_colors()} returns an overview of the names of the available colors
These are the standard colors also returned by \code{\link[grDevices:colors]{grDevices::colors()}} plus a default
table color with the name "default".
}
\examples{
\dontshow{if (rlang::is_installed(c("nycflights13", "DiagrammeR"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_nycflights13(color = FALSE) \%>\%
  dm_set_colors(
    darkblue = starts_with("air"),
    "#5986C4" = flights
  ) \%>\%
  dm_draw()

# Splicing is supported:
nyc_cols <-
  dm_nycflights13() \%>\%
  dm_get_colors()
nyc_cols

dm_nycflights13(color = FALSE) \%>\%
  dm_set_colors(!!!nyc_cols) \%>\%
  dm_draw()
\dontshow{\}) # examplesIf}
}
