% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_index.R, R/make_index.dmdSchemeSet.R
\name{make_index}
\alias{make_index}
\alias{make_index.dmdSchemeSet}
\title{Generic function to create the \code{index.md} file to accompany the data
deposit package}
\usage{
make_index(
  scheme,
  path = ".",
  overwrite = FALSE,
  template = scheme_path_index_template(),
  author = NULL,
  make = c("html", "pdf"),
  pandoc_bin = "pandoc",
  pandoc_args = "-s",
  ...
)

\method{make_index}{dmdSchemeSet}(
  scheme,
  path = ".",
  overwrite = FALSE,
  template = scheme_path_index_template(),
  author = NULL,
  make = c("pdf", "html"),
  pandoc_bin = "pandoc",
  pandoc_args = "-s",
  ...
)
}
\arguments{
\item{scheme}{a dmdScheme from which the values for the tokens in the
\code{template} should be taken}

\item{path}{path to where the `index` should be created. The file name of the
created index is identical to the file name of the template.}

\item{overwrite}{if TRUE, the target index file will be overwritten
automatically, unless the target index is equal to the template, in which
case, an error would be raised in all cases.}

\item{template}{template to be used for the index file. For details see the
vignette \bold{Create and Customize the index template}. The default
template is at \code{system.file("index.md", package = "dmdScheme")}}

\item{author}{of the index file}

\item{make}{character vector containing types into which the generated index
file should be converted to. default is html and pdf. \bold{This function
uses pandoc for the conversion!.}}

\item{pandoc_bin}{pandoc executable. Needs fully qualified path when not in
\code{$PATH}.}

\item{pandoc_args}{arguments for calling pandoc}

\item{...}{additional arguments for methods}
}
\value{
returns path to the created \code{index.md} file
}
\description{
Generic function to create the \code{index.md} file to accompany the data
deposit package

Title
}
\examples{
\dontrun{
  # takes to long for CRAN
  make_index( dmdScheme_example(), path = tempdir() )
}

}
