% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{subset.dnapath_list}
\alias{subset.dnapath_list}
\title{Subset function for 'dnapath_list' object.}
\usage{
\method{subset}{dnapath_list}(x, pathways = NULL, genes = NULL, ...)
}
\arguments{
\item{x}{A 'dnapath_list' object from \code{\link{dnapath}}.}

\item{pathways}{A set of pathways to index on. This can be (1) a vector of
character strings, corresponding to
pathway names or regular expressions used to find pathways, (2) a vector of
indices to select pathways, (3) a vector of
negative indices indicating pathways to remove, or (4) a logical (boolean)
vector  that is the same length of current number of pathways in \code{x}.}

\item{genes}{A set of gene names to index on; exact matching is used. Only
pathways containing these genes are retained.}

\item{...}{Additional arguments are ignored.}
}
\value{
A subset of the differential network analysis results.
}
\description{
Subset function for 'dnapath_list' object.
}
\examples{
data(meso)
# Obtain a pathway list for this short example:
pathway_list <- get_reactome_pathways("human", overlap_limit = NULL,
                                      min_size = 13, max_size = 19)
# Run the differential network analysis.
results <- dnapath(x = meso$gene_expression, pathway_list = pathway_list,
                   group_labels = meso$groups, n_perm = 5, seed = 0)
summary(results) # Summary over all pathways in the pathway list.

# Subset on pathways that contain "cell cycle" in its name.
cell_cycle_pathways <- subset(results, pathways = "cell cycle")
summary(cell_cycle_pathways)
# Subset on pathways that contain the gene 1026 (Entrezgene ID).
pathways_with_1026 <- subset(results, genes = "1026")
summary(pathways_with_1026)

# Multiple pathways and/or genes can also be specified. 
# Specifying both acts as an "OR" operation. For example, the following subset 
# will contain pathways containing the words "acetylation" or "methylation" 
# OR pathways that contain the genes "1108" or "11200". 
results_OR <- subset(results, 
                     pathways = c("acetylation", "methylation"),
                     genes = c("1108", "11200"))
summary(results_OR)
# To subset on pathways that have both a specific pathway name AND
# certain genes, call the subset function twice: once specifying the
# `pathways` argument, then pass those results back into subset() with the
# `genes` argument specified. For example:
results_AND <- subset(results, 
                      pathways = c("acetylation", "methylation"))
results_AND <- subset(results_AND,
                      genes = c("1108", "11200"))
summary(results_AND)
}
