% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apriori.Basket.R
\name{Apriori.Basket}
\alias{Apriori.Basket}
\title{Convert vector to sparse matrix}
\usage{
Apriori.Basket(x, sep = ";", dup.delete = FALSE)
}
\arguments{
\item{x}{a vector}

\item{sep}{one separator}

\item{dup.delete}{whether to delete duplicated values in the same row, default is FALSE}
}
\value{
a sparse matrix
}
\description{
Convert vector or dataframe to sparse matrix.
}
\examples{
# convert a vector to sparse matrix
g=c('a,b,a,,','a,b,c,d','d,c,f,g,h')
Apriori.Basket(x=g,sep = ',')

# convert a dataframe to sparse matrix
library(data.table)
df=fread(text = '
t1 t2 t3
a NA d
g a j')
Apriori.Basket(x=df,sep = ',')
}
