% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVE3_LinearPred.R
\name{CVE_LP}
\alias{CVE_LP}
\title{Cross-validation for cox regression using the linear predictor estimator with
wrapper for warnings handling}
\usage{
CVE_LP(x)
}
\arguments{
\item{x}{list of 3 named elements : \code{data} (data containing columns time
and status), \code{partition} (dataframe with 1 column), \code{nfolds}
(number of fold for cross-validation).}
}
\value{
numeric, cross-validation error
}
\description{
Cross-validation for cox regression using the linear predictor estimator with
wrapper for warnings handling
}
\examples{
data(cancer, package = "survival")
cancer$status <- cancer$status - 1
part <- data.frame(Cl= factor(cancer[, "sex"]), stringsAsFactors = TRUE)
CVE_LP(list(data = cancer, partition = part, nfolds = 10))
}
