% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanUp_partition.R
\name{cleanUp_partition}
\alias{cleanUp_partition}
\title{Remove small clusters (i.e. unclassified observations for which no consensus
was obtained)}
\usage{
cleanUp_partition(
  partition,
  min.cluster.size = 10,
  level.order = NULL,
  Unclassified = c(NA, "Unclassified")
)
}
\arguments{
\item{partition}{the partition to clean (vector).}

\item{min.cluster.size}{Minimum cluster size (i.e., smaller clusters will be
discarded)}

\item{level.order}{optional. If you supply a variable the  cluster levels
will be ordinated according to the mean values for the variable}

\item{Unclassified}{string for the label of the unclassified observations.
defaults value is \code{NA}.}
}
\value{
The cleaned up partition (factor).
}
\description{
Remove small clusters (i.e. unclassified observations for which no consensus
was obtained)
}
\examples{
part <- factor(kmeans(iris[, 1:4], 8)$cluster)
summary(part)
part.clean <- cleanUp_partition(part, Unclassified = "Unclassified")
}
