# WARNING - Generated by {fusen} from dev/flat_dock_from_renv.Rmd: do not edit by hand

# A temporary directory
dir_build <- tempfile(pattern = "renv")
dir.create(dir_build)

# Create a lockfile
the_lockfile <- file.path(dir_build, "renv.lock")

custom_packages <- c(
  # attachment::att_from_description(),
  "cli",
  "glue", # "golem",
  "shiny",
  "stats",
  "utils",
  "testthat",
  "knitr"
)
try(dockerfiler::renv$initialize(),silent=TRUE)
if ( !testthat:::on_cran()){
dockerfiler::renv$snapshot(
  packages = custom_packages,
  lockfile = the_lockfile,
  prompt = FALSE
) } else {
    file.copy(from = system.file("renv.lock",package = "dockerfiler"),to = the_lockfile)
}

# Modify R version for tests
renv_file <- readLines(file.path(dir_build, "renv.lock"))
renv_file[grep("Version", renv_file)[1]] <- '    "Version": "4.1.2",'
writeLines(renv_file, file.path(dir_build, "renv.lock"))



# dock_from_renv ----
test_that("dock_from_renv works", {
  # testthat::skip_on_cran()
  # skip_if_not(interactive())
  # Create Dockerfile

  out <- dock_from_renv(
    lockfile = the_lockfile,
    distro = "focal",
    FROM = "rocker/verse",
  )
  expect_s3_class(
    out,
    "Dockerfile"
  )
  expect_s3_class(
    out,
    "R6"
  )
  # read Dockerfile
  out$write(
    file.path(
      dir_build,
      "Dockerfile"
    )
  )

  dock_created <- readLines(
    file.path(
      dir_build,
      "Dockerfile"
    )
  )
  expect_equal(
    dock_created[1],
    "FROM rocker/verse:4.1.2"
  )

  expect_length(
    grep("RUN R -e 'renv::restore\\(\\)'", dock_created),
    1
  )

  # System dependencies are different when build in interactive environment?
  # yes.  strange.
  skip_if_not(interactive())
  dir.create(
    file.path(
      dir_build,
      "inst"
    )
  )
  file.copy(
    file.path(
      dir_build,
      "Dockerfile"
    ),
    file.path(
      dir_build,
      "inst"
    ),
    overwrite = TRUE
  )
  dock_expected <- readLines(
    system.file(
      "renv_Dockefile",
      package = "dockerfiler"
    )
  )

  expect_equal(dock_created, dock_expected)
})
# rstudioapi::navigateToFile(file.path(dir_build, "Dockerfile"))
unlink(dir_build)

# repos_as_character ----
test_that("repos_as_character works", {
  out <- dockerfiler:::repos_as_character(
    repos = c(
      RSPM = paste0("https://packagemanager.rstudio.com/all/__linux__/focal/latest"),
      CRAN = "https://cran.rstudio.com/"
    )
  )
  expect_equal(
    out,
    "c(RSPM = 'https://packagemanager.rstudio.com/all/__linux__/focal/latest', CRAN = 'https://cran.rstudio.com/')"
  )
})

# gen_base_image ----
test_that("gen_base_image works", {
  out <- dockerfiler:::gen_base_image(
    distro = "focal",
    r_version = "4.0",
    FROM = "rstudio/r-base"
  )
  expect_equal(out, "rstudio/r-base:4.0-focal")

  out <- dockerfiler:::gen_base_image(
    distro = "focal",
    r_version = "4.0",
    FROM = "rocker/verse"
  )
  expect_equal(out, "rocker/verse:4.0")
})





test_that("dock_from_renv works with specific renv", {
  # testthat::skip_on_cran()
the_lockfile1.0.0 <- system.file("renv_with_1.0.0.lock",package = "dockerfiler")

for (lf in list(the_lockfile,the_lockfile1.0.0)){
for (renv_version in list(NULL,"banana","missing")){


  if (!is.null(renv_version) && renv_version == "missing") {
    out <- dock_from_renv(lockfile = lf,
                          distro = "focal",
                          FROM = "rocker/verse")
  } else{
    out <- dock_from_renv(
      lockfile = lf,
      distro = "focal",
      FROM = "rocker/verse",
      renv_version = renv_version
    )

  }
socle_install_version <- "remotes::install_version\\(\"renv\", version = \""
  if (lf == the_lockfile &    is.null(renv_version)) {
    test_string <- 'install.packages\\(c\\(\"renv\",\"remotes\"))'
  } else if (lf == the_lockfile1.0.0 & is.null(renv_version)) {
    test_string <- 'install.packages\\(c\\(\"renv\",\"remotes\"))'
  } else if (lf == the_lockfile &  renv_version == "banana") {
    test_string <-  paste0(socle_install_version,"banana"  ,"\"\\)")
  } else if (lf == the_lockfile1.0.0 & renv_version == "banana") {
    test_string <- paste0(socle_install_version,"banana","\"\\)")
  } else if (lf == the_lockfile & renv_version == "missing") {
    test_string <-
      paste0(
        socle_install_version,dockerfiler::renv$the$metadata$version,"\"\\)"
      )
  } else if (lf == the_lockfile1.0.0 & renv_version == "missing") {
    test_string <-paste0(socle_install_version,"1.0.0","\"\\)")
  }

  expect_true( any(   grepl(test_string , out$Dockerfile)    ),
               info = paste(lf," & ",renv_version))


}}  
  
  
  

})

