% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_gap.R
\name{put_gap}
\alias{put_gap}
\title{Insert a gap or whitespace in a document.}
\usage{
put_gap(col = NULL, fill = NULL)
}
\arguments{
\item{col}{: Border color, default is \code{"transparent"}}

\item{fill}{: Fill color, default is \code{"transparent"}}
}
\value{
Prints the box to the output document.
}
\description{
Creates white space in a document by creating an empty plot in \code{ggplot2}. Border and fill can be specified to create a box. The defaults are transparent.
}
\details{
Allows the author of Rmd to docx documents to insert a vertical white space of specified height, particularly useful in creating documents that users are expected to write in, such as workshop or student lab materials.

The dimensions of the gap are determined when it is printed, e.g., using \code{knitr} in an R Markdown script, the box height in inches is set with the \code{fig.height} code chunk option.
}
\examples{
put_gap()
put_gap(col = "gray")
put_gap(col = "black", fill = "gray")

\dontrun{
# In an R Markdown script
```{r fig.height = 0.75}
put_gap()
```}

}

