#' Ideal gas sample data frame
#'
#' Air density at room temperature. A data frame to illustrate features of
#' the \code{format_engr()} and \code{align_pander()} functions.
#'
#' @usage data(density)
#'
#' @format A data frame with columns:
#' \describe{
#'  \item{date}{A date variable.}
#'  \item{trial}{A character variable.}
#'  \item{T_K}{Numeric air temperature in Kelvin.}
#'  \item{p_Pa}{Numeric air pressure in Pascals.}
#'  \item{R}{Numeric gas constant in J/(kg K)}
#'  \item{density}{Numeric air density in kg/m^3}
#' }
"density"
