% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists.R
\name{dodgr_dists}
\alias{dodgr_dists}
\title{dodgr_dists}
\usage{
dodgr_dists(graph, from, to, wt_profile = "bicycle", heap = "BHeap",
  quiet = TRUE)
}
\arguments{
\item{graph}{\code{data.frame} or equivalent object representing the network
graph (see Details)}

\item{from}{Vector or matrix of points **from** which route distances are to
be calculated (see Details)}

\item{to}{Vector or matrix of points **to** which route distances are to be
calculated (see Details)}

\item{wt_profile}{Name of weighting profile for street networks (one of foot,
horse, wheelchair, bicycle, moped, motorcycle, motorcar, goods, hgv, psv).}

\item{heap}{Type of heap to use in priority queue. Options include
Fibonacci Heap (default; \code{FHeap}), Binary Heap (\code{BHeap}),
\code{Radix}, Trinomial Heap (\code{TriHeap}), Extended Trinomial Heap
(\code{TriHeapExt}, and 2-3 Heap (\code{Heap23}).}

\item{quiet}{If \code{FALSE}, display progress messages on screen.}
}
\value{
square matrix of distances between nodes
}
\description{
dodgr_dists
}
\note{
\code{graph} must minimially contain four columns of \code{from},
\code{to}, \code{dist}. If an additional column named \code{weight} or
\code{wt} is present, shortest paths are calculated according to values
specified in that column; otherwise according to \code{dist} values. Either
way, final distances between \code{from} and \code{to} points are calculated
according to values of \code{dist}. That is, paths between any pair of points
will be calculated according to the minimal total sum of \code{weight}
values (if present), while reported distances will be total sums of
\code{dist} values.

The \code{from} and \code{to} columns of \code{graph} may be either single
columns of numeric or character values specifying the numbers or names of
graph vertices, or combinations to two columns specifying geographical
(longitude and latitude) coordinates. In the latter case, almost any sensible
combination of names will be accepted (for example, \code{fromx, fromy},
\code{from_x, from_y}, or \code{fr_lat, fr_lon}.)

\code{from} and \code{to} values can be either two-column matrices of
equivalent of longitude and latitude coordinates, or else single columns
precisely matching node numbers or names given in \code{graph$from} or
\code{graph$to}. If \code{to} is missing, pairwise distances are calculated
between all points specified in \code{from}. If neither \code{from} nor
\code{to} are specified, pairwise distances are calcualted between all nodes
in \code{graph}.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 100)
to <- sample (graph$to_id, size = 50)
d <- dodgr_dists (graph, from = from, to = to)
# d is a 100-by-50 matrix of distances between \\code{from} and \\code{to}
}
