% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-points.R
\name{add_nodes_to_graph}
\alias{add_nodes_to_graph}
\title{Insert new nodes into a graph, breaking edges at point of nearest
intersection.}
\usage{
add_nodes_to_graph(graph, xy)
}
\arguments{
\item{graph}{A \code{dodgr} graph with spatial coordinates, such as a
\code{dodgr_streetnet} object.}

\item{xy}{coordinates of points to be matched to the vertices, either as
matrix or \pkg{sf}-formatted \code{data.frame}.}
}
\value{
A modified version of \code{graph}, with additional edges formed by
breaking previous edges at nearest penpendicular intersections with the
points, \code{xy}.
}
\description{
The "id" value of each edge to be divided through insertion of new points is
modified to produce two new "id" values with suffixes "_A" and "_B". This
routine presumes graphs to be \code{dodgr_streetnet} object, with geographical
coordinates.
}
\examples{
graph <- weight_streetnet (hampi, wt_profile = "foot")
dim (graph)

verts <- dodgr_vertices (graph)
set.seed (2)
npts <- 10
xy <- data.frame (
    x = min (verts$x) + runif (npts) * diff (range (verts$x)),
    y = min (verts$y) + runif (npts) * diff (range (verts$y))
)

graph <- add_nodes_to_graph (graph, xy)
dim (graph) # more edges than original
}
\seealso{
Other match: 
\code{\link{match_points_to_graph}()},
\code{\link{match_points_to_verts}()},
\code{\link{match_pts_to_graph}()},
\code{\link{match_pts_to_verts}()}
}
\concept{match}
