% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional.R
\name{gof}
\alias{gof}
\alias{print.gof.dosresmeta}
\title{Computes statistics to evaluate the goodness-of-fit from dosresmeta Objects}
\usage{
gof(object, fixed = TRUE)

\method{print}{gof.dosresmeta}(x, digits = 3, ...)
}
\arguments{
\item{object}{an object of class \code{dosresmeta} produced by \code{\link{dosresmeta}}.}

\item{fixed}{logical for selecting fixed model. By default equal to \code{TRUE}.}

\item{x}{an object of class \code{gof.dosresmeta} produced by \code{gof}.}

\item{digits}{an integer specifying the number of digits to which printed results must be rounded.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
A list of class \code{gof.dosresmeta} containing the following
\tabular{ll}{
\code{tdata} \tab a dataframe with the decorrelated variables (y*, X*, e*).\cr
\code{R2} \tab Coefficient of determination R^2.\cr
\code{deviance} \tab Deviance test.\cr
}
}
\description{
This function computes statistics to evaluate the goodness-of-fit for dose-response meta-analysis.
It implements the deviance test, the coefficient of determination, and a dataframe useful for a decorrelated residuals-versus-exposure plot.
See reference for more details
}
\examples{
## Loading the data
data("milk_ov")

## Linear dose-response model
lin <- dosresmeta(formula = logrr ~ dose, type = type, id = id,
                 se = se, cases = case, n = n, data = milk_ov)
                 
## Display goodness-of-fit statistics
gof(lin)

## Meta-regression model
lin_reg <- dosresmeta(formula = logrr ~ dose, type = type, id = id,
  se = se, cases = case, n = n, data = milk_ov,
  mod = ~ type)

## Display goodness-of-fit statistics for meta-regression model
gof(lin_reg)
 
}
\references{
Discacciati A, Crippa A, Orsini N. Goodness of fit tools for dose-response meta-analysis of binary outcomes. 
Research synthesis methods. 2015 Jan 1.
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
