% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{writeLineageFile}
\alias{writeLineageFile}
\title{Write lineage file for IgPhyML use}
\usage{
writeLineageFile(
  data,
  trees = NULL,
  dir = ".",
  id = "N",
  rep = NULL,
  trait = NULL,
  empty = TRUE,
  partition = "single",
  heavy = "IGH"
)
}
\arguments{
\item{data}{list of \code{airrClone} objects}

\item{trees}{list of \code{phylo} objects corresponding to \code{data}}

\item{dir}{directory to write file}

\item{id}{id used for IgPhyML run}

\item{rep}{bootstrap replicate}

\item{trait}{string appended to sequence id in fasta files}

\item{empty}{output uninformative sequences?}

\item{partition}{how to partition omegas}

\item{heavy}{name of heavy chain locus}
}
\value{
Name of created lineage file.
}
\description{
Write lineage file for IgPhyML use
}
