% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clones.R
\name{maskCodons}
\alias{maskCodons}
\title{\code{maskCodons} Masks codons split by insertions}
\usage{
maskCodons(
  id,
  q,
  s,
  keep_alignment = FALSE,
  gap_opening = 5,
  gap_extension = 1,
  keep_insertions = FALSE,
  mask = TRUE
)
}
\arguments{
\item{id}{sequence id}

\item{q}{(query) un-aligned input sequence (sequence)}

\item{s}{(subject) aligned input sequence (sequence_alignment)}

\item{keep_alignment}{store q and s alignments}

\item{gap_opening}{gap opening penalty (Biostrings::pairwiseAlignment)}

\item{gap_extension}{gap extension penalty (Biostrings::pairwiseAlignment)}

\item{keep_insertions}{return removed insertion sequences?}

\item{mask}{if FALSE, don't mask codons}
}
\value{
A list with split codons masked, if found (sequence_masked).
}
\description{
\code{maskCodons} Masks codons split by insertions
}
\details{
Performs global alignment of q and s, masks codons in s that are split by 
insertions (see example)
masking_note notes codon positions in subject_alignment sequence that were 
masked, if found.
subject_alignment contains subject sequence aligned to query (q) sequence
query_alignment contains query sequence aligned to subject (q) sequence
sequence_masked will be NA if frameshift or alignment error detected/
}
\examples{
s = "ATCATCATC..."
q = "ATCTTTATCATC"
print(maskCodons(1,q,s,TRUE))

s <- "ATCATCATC..."
q <- "ATTTTCATCATC"
print(maskCodons("test",q,s,keep_alignment=TRUE,keep_insertions=TRUE))
}
\seealso{
\link{maskSequences}, Biostrings::pairwiseAlignment.
}
