% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dpcr.R
\name{read_raw}
\alias{read_raw}
\title{Read digital PCR raw data}
\usage{
read_raw(input, adpcr)
}
\arguments{
\item{input}{name of the input file (\code{character}) or input object 
(\code{data.frame}).}

\item{adpcr}{\code{logical}. If \code{TRUE}, function creates
\code{\linkS4class{adpcr}} object. If \code{FALSE}, function creates
\code{\linkS4class{ddpcr}} object.}
}
\value{
An object of \code{\linkS4class{adpcr}} or \code{\linkS4class{ddpcr}} type, 
depends on the value of \code{adpcr} parameter.
}
\description{
Reads digital PCR data in raw format.
}
\details{
The raw format means that every column corresponds to different digital PCR run. 
Data is binary (0/1) and first row represents run names(EXPERIMENT.REPLICATE).
}
\author{
Michal Burdukiewcz, Stefan Roediger
}
\keyword{utilities}

