% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/TruncSeriesPithoffset.R
\name{TruncSeriesPithoffset}
\alias{TruncSeriesPithoffset}
\title{Truncate series by range pithoffsets}
\usage{
TruncSeriesPithoffset(file.raw, file.stand, pithoffset, range)
}
\arguments{
\item{file.raw}{data file containing the raw ring widths, in mm}

\item{file.stand}{data file containing the standardized ring widths}

\item{pithoffset}{data set containing the pith offsets for each core, in mm.}

\item{range}{The distance from the pith use for truncation, given in mm from the core. e.g. range <- c(1,200) truncates values outside this range.}
}
\value{
\item{sub.series.raw}{A truncated series of raw ring widths (in miromilmeter).}
\item{sub.series.stand}{A truncated series of standardized ring widths (in miromilmeter).}
}
\description{
The following function truncate the data by a given range from the estimated pith.
}
\examples{
\dontrun{
data(ring.raw)
data(ring.stand)
data(dbh.po.nc)
#Subset near-pith is the material within 0 -20cm from the estimated pith
spline200.sub0.20.n   <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(1,200))
# Subset far-pith is the material further than 20cm from the estimated pith
spline200.sub20.2000.n  <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(200,200000))
# Whole dataset, through truncated functions to get in the same formate as the above two datasets
spline200.sub0.2000.n  <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(00,200000))}
}

