% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Figure_concordance.R
\name{figure.function.concordance}
\alias{figure.function.concordance}
\title{Figure: Plots the Concordances}
\usage{
figure.function.concordance(con.indices, x.lim)
}
\arguments{
\item{con.indices}{This is the output generated from the function overall.concordance.period.}

\item{x.lim}{This is a vector with the start and end year for the required plot.}
}
\value{
A figure with the concordance indices and their confidence intervals, a smoother fitted through the indices and the confidence interval for the mean concordance.
}
\description{
Plots the concordance indices. This is used to generate the Figure in Concordance: A measure of similarity between matrices of time series with applications in dendroclimatology".
}
\examples{
\dontrun{
#Subset "near-pith" is the material within 0 -20cm from the estimated pith
spline200.sub0.20.n   <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(1,200))
spline200.sub20.2000.n  <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(200,200000))
boot.0.20   <-  series.bootstrap( spline200.sub0.20.n$sub.series.stand, stat, 999,
    names.stat, aver.by.tree = FALSE)
boot.20.2000   <- series.bootstrap(spline200.sub20.2000.n$sub.series.stand, stat, 999,
   names.stat, aver.by.tree = FALSE)

overall.precision.HUP <- overall.concordance.period(spline200.sub20.2000.n$sub.series.stand ,
   spline200.sub0.20.n$sub.series.stand,
   boot.20.2000$boot.series.mean,  boot.0.20$boot.series.mean ,1 , concordance.indices,
   c(1880,1999), trim.alpha=0.005, concordance.beta=0.5)

figure.function.concordance (overall.precision.HUP, x.lim=c(1880,2000))}
}
\author{
Maryann Pirie
}

