% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{select}
\alias{select}
\alias{rename}
\title{Select/rename variables by name}
\usage{
select(.data, ...)

rename(.data, ...)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link[=tbl_df]{tbl_df()}}, \code{\link[dtplyr:tbl_dt]{dtplyr::tbl_dt()}} and \code{\link[dbplyr:tbl_dbi]{dbplyr::tbl_dbi()}}.}

\item{...}{One or more unquoted expressions separated by commas.
You can treat variable names like they are positions, so you can
use expressions like \code{x:y} to select ranges of variables.

Positive values select variables; negative values drop variables.
If the first expression is negative, \code{select()} will automatically
start with all variables.

Use named arguments, e.g. \code{new_name = old_name}, to rename selected variables.

The arguments in \code{...} are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in a context where column names
represent column positions. They also support
\link[rlang:quasiquotation]{unquoting} and splicing. See
\code{vignette("programming")} for an introduction to these concepts.

See \link[tidyselect:select_helpers]{select helpers} for more details and
examples about tidyselect helpers such as \code{starts_with()}, \code{everything()}, ...}
}
\value{
An object of the same class as \code{.data}.
}
\description{
Choose or rename variables from a tbl.
\code{select()} keeps only the variables you mention; \code{rename()}
keeps all variables.
}
\details{
These functions work by column index, not value; thus, an expression
like \code{select(data.frame(x = 1:5, y = 10), z = x+1)} does not create a variable
with values \code{2:6}. (In the current implementation, the expression \code{z = x+1}
wouldn't do anything useful.)  To calculate using column values, see
\code{\link[=mutate]{mutate()}}/\code{\link[=transmute]{transmute()}}.
}
\section{Useful functions}{

As well as using existing functions like \code{:} and \code{c()}, there are
a number of special functions that only work inside \code{select()}:
\itemize{
\item \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}
\item \code{\link[=matches]{matches()}}
\item \code{\link[=num_range]{num_range()}}
\item \code{\link[=one_of]{one_of()}}
\item \code{\link[=everything]{everything()}}
\item \code{\link[=group_cols]{group_cols()}}
}

To drop variables, use \code{-}.

Note that except for \code{:}, \code{-} and \code{c()}, all complex expressions
are evaluated outside the data frame context. This is to prevent
accidental matching of data frame variables when you refer to
variables from the calling context.
}

\section{Scoped selection and renaming}{


The three \link{scoped} variants of \code{select()} (\code{\link[=select_all]{select_all()}},
\code{\link[=select_if]{select_if()}} and \code{\link[=select_at]{select_at()}}) and the three variants of
\code{rename()} (\code{\link[=rename_all]{rename_all()}}, \code{\link[=rename_if]{rename_if()}}, \code{\link[=rename_at]{rename_at()}}) make it
easy to apply a renaming function to a selection of variables.
}

\section{Tidy data}{

When applied to a data frame, row names are silently dropped. To preserve,
convert to an explicit variable with \code{\link[tibble:rownames_to_column]{tibble::rownames_to_column()}}.
}

\examples{
iris <- as_tibble(iris) # so it prints a little nicer
select(iris, starts_with("Petal"))
select(iris, ends_with("Width"))

# Move Species variable to the front
select(iris, Species, everything())

# Move Sepal.Length variable to back
# first select all variables except Sepal.Length, then re select Sepal.Length
select(iris, -Sepal.Length, Sepal.Length)

df <- as.data.frame(matrix(runif(100), nrow = 10))
df <- tbl_df(df[c(3, 4, 7, 1, 9, 8, 5, 2, 6, 10)])
select(df, V4:V6)
select(df, num_range("V", 4:6))

# Drop variables with -
select(iris, -starts_with("Petal"))

# Select the grouping variables:
starwars \%>\% group_by(gender) \%>\% select(group_cols())


# The .data pronoun is available:
select(mtcars, .data$cyl)
select(mtcars, .data$mpg : .data$disp)

# However it isn't available within calls since those are evaluated
# outside of the data context. This would fail if run:
# select(mtcars, identical(.data$cyl))


# Renaming -----------------------------------------
# * select() keeps only the variables you specify
select(iris, petal_length = Petal.Length)

# * rename() keeps all variables
rename(iris, petal_length = Petal.Length)

# * select() can rename variables in a group
select(iris, obs = starts_with('S'))

# Unquoting ----------------------------------------

# Like all dplyr verbs, select() supports unquoting of symbols:
vars <- list(
  var1 = sym("cyl"),
  var2 = sym("am")
)
select(mtcars, !!!vars)

# For convenience it also supports strings and character
# vectors. This is unlike other verbs where strings would be
# ambiguous.
vars <- c(var1 = "cyl", var2 ="am")
select(mtcars, !!vars)
rename(mtcars, !!vars)
}
\seealso{
Other single table verbs: \code{\link{arrange}},
  \code{\link{filter}}, \code{\link{mutate}},
  \code{\link{slice}}, \code{\link{summarise}}
}
\concept{single table verbs}
