% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icon_state_button.R
\name{icon_state_button}
\alias{icon_state_button}
\alias{update_icon_state_button}
\title{Creates a state button showing different icons}
\usage{
icon_state_button(id, states, value = NULL, ...)

update_icon_state_button(session, id, states = NULL, value = NULL)
}
\arguments{
\item{id}{id of the element}

\item{states}{character of possible states, must be valid FontAwesome icon
names \code{\link[shiny:icon]{icon}}}

\item{value}{optional value, can be integer position in states or
character giving the state, must be of length one}

\item{...}{additional parameters like CSS classes or styles}

\item{session}{the shiny session object}
}
\value{
icon_state_button: shiny input element

update_icon_state_button: message to the client
}
\description{
Creates a state button showing different states by different
icons.

Changes the value or the options of an icon_state_button
on the client side.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
hands <- paste0("hand-point-", c("up", "right", "down", "left"))
shinyApp(
  ui = fluidPage(
    fluidRow(column(12,
      icon_state_button("sort", c("sort", "sort-up", "sort-down")),
      icon_state_button("hands", hands, 1),
      icon_state_button("mood", c("smile", "meh", "frown"), "smile"),
      br(), actionButton("makeStars", "I like stars")
    ))
  ),
  server = function(input, output, session) {
    observeEvent(input$makeStars, update_icon_state_button(
      session, "mood", list(star = dq_icon("star"), dq_icon("star-half"),
        dq_icon("star-half", style = "far"), dq_icon("star", style = "far")
      ), value = "star"
    ))
  }
)

}
}
\author{
richard.kunze
}
