% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{new_cache}
\alias{new_cache}
\title{Make a new \code{drake} cache.}
\usage{
new_cache(path = drake::default_cache_path(), verbose = 1, type = NULL,
  short_hash_algo = drake::default_short_hash_algo(),
  long_hash_algo = drake::default_long_hash_algo(), ...)
}
\arguments{
\item{path}{file path to the cache if the cache
is a file system cache.}

\item{verbose}{logical, whether to print out the path of the cache.}

\item{type}{deprecated argument. Once stood for cache type.
Use \code{storr} to customize your caches instead.}

\item{short_hash_algo}{short hash algorithm for the cache.
See \code{\link{default_short_hash_algo}()} and
\code{\link{make}()}}

\item{long_hash_algo}{long hash algorithm for the cache.
See \code{\link{default_long_hash_algo}()} and
\code{\link{make}()}}

\item{...}{other arguments to the cache constructor}
}
\value{
A newly created drake cache as a storr object.
}
\description{
Uses the \code{storr_rds()} function
from the \code{storr} package.
}
\examples{
\dontrun{
test_with_dir("Quarantine new_cache() side effects.", {
clean(destroy = TRUE) # Should not be necessary.
unlink("not_hidden", recursive = TRUE) # Should not be necessary.
cache1 <- new_cache() # Creates a new hidden '.drake' folder.
cache2 <- new_cache(path = "not_hidden", short_hash_algo = "md5")
clean(destroy = TRUE, cache = cache2)
})
}
}
\seealso{
\code{\link{default_short_hash_algo}},
\code{\link{default_long_hash_algo}},
\code{\link{make}}
}
