% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{drake_session}
\alias{drake_session}
\title{Return the \code{\link[=sessionInfo]{sessionInfo()}}
of the last call to \code{\link[=make]{make()}}.}
\usage{
drake_session(path = getwd(), search = TRUE, cache = drake::get_cache(path
  = path, search = search, verbose = verbose),
  verbose = drake::default_verbose())
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}
}
\value{
\code{\link[=sessionInfo]{sessionInfo()}} of the last
call to \code{\link[=make]{make()}}
}
\description{
By default, session info is saved
during \code{\link[=make]{make()}} to ensure reproducibility.
Your loaded packages and their versions are recorded, for example.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
make(my_plan) # Run the project, build the targets.
drake_session() # Retrieve the cached sessionInfo() of the last make().
})
}
}
\seealso{
\code{\link[=diagnose]{diagnose()}}, \code{\link[=built]{built()}}, \code{\link[=imported]{imported()}},
\code{\link[=readd]{readd()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
