% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{drake_build}
\alias{drake_build}
\title{Build/process a single target or import.}
\usage{
drake_build(target, config = drake::read_drake_config(envir = envir, jobs =
  jobs), meta = NULL, character_only = FALSE, envir = parent.frame(),
  jobs = 1, replace = FALSE)
}
\arguments{
\item{target}{name of the target}

\item{config}{internal configuration list}

\item{meta}{list of metadata that tell which
targets are up to date (from \code{\link[=drake_meta]{drake_meta()}}).}

\item{character_only}{logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}

\item{envir}{environment to load objects into. Defaults to the
calling environment (current workspace).}

\item{jobs}{number of parallel jobs for loading objects. On
non-Windows systems, the loading process for multiple objects
can be lightly parallelized via \code{parallel::mclapply()}.
just set jobs to be an integer greater than 1. On Windows,
\code{jobs} is automatically demoted to 1.}

\item{replace}{logical. If \code{FALSE},
items already in your environment
will not be replaced.}
}
\value{
The value of the target right after it is built.
}
\description{
For internal use only.
the only reason this function is exported
is to set up parallel socket (PSOCK) clusters
without much of a fuss.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# This example is not really a user-side demonstration.
# It just walks through a dive into the internals.
# Populate your workspace and write 'report.Rmd'.
load_mtcars_example() # Get the code with drake_example("mtcars").
# Create the master internal configuration list.
config <- drake_config(my_plan)
out <- drake_build(small, config = config)
# Now includes `small`.
cached()
head(readd(small))
# `small` was invisibly returned.
head(out)
# If you previously called make(),
# `config` is just read from the cache.
make(my_plan, verbose = FALSE)
result <- drake_build(small)
head(result)
})
}
}
