% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-codetoplan.R
\name{code_to_plan}
\alias{code_to_plan}
\title{Turn an R script file or knitr / R Markdown report
into a \code{drake} workflow plan data frame.}
\usage{
code_to_plan(path)
}
\arguments{
\item{path}{A file path to an R script or \code{knitr} report.}
}
\description{
\code{code_to_plan()}, \code{\link[=plan_to_code]{plan_to_code()}}, and
\code{\link[=plan_to_notebook]{plan_to_notebook()}} together illustrate the relationships
between \code{drake} plans, R scripts, and R Markdown documents.
}
\details{
This feature is easy to break, so there are some rules
for your code file:
\enumerate{
\item Stick to assigning a single expression to a single target at a time.
For multi-line commands, please enclose the whole command
in curly braces.
Conversely, compound assignment is not supported
(e.g. \code{target_1 <- target_2 <- target_3 <- get_data()}).
\item Once you assign an expression to a variable,
do not modify the variable any more.
The target/command binding should be permanent.
\item Keep it simple. Please use the assignment operators rather than
\code{assign()} and similar functions.
}
}
\examples{
plan <- drake_plan(
  raw_data = read_excel(file_in("raw_data.xlsx")),
  data = raw_data,
  hist = create_plot(data),
  fit = lm(Sepal.Width ~ Petal.Width + Species, data)
)
file <- tempfile()
# Turn the plan into an R script a the given file path.
plan_to_code(plan, file)
# Here is what the script looks like.
cat(readLines(file), sep = "\\n")
# Convert back to a drake plan.
if (requireNamespace("CodeDepends")) {
  code_to_plan(file)
}
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}, \code{\link[=plan_to_code]{plan_to_code()}},
\code{\link[=plan_to_notebook]{plan_to_notebook()}}
}
