% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-clean.R
\name{rescue_cache}
\alias{rescue_cache}
\title{Try to repair a drake cache that is prone
to throwing \code{storr}-related errors.}
\usage{
rescue_cache(targets = NULL, path = getwd(), search = TRUE,
  verbose = 1L, force = FALSE, cache = drake::get_cache(path = path,
  search = search, verbose = verbose, force = force), jobs = 1,
  garbage_collection = FALSE)
}
\arguments{
\item{targets}{Character vector, names of the targets to rescue.
As with many other drake utility functions, the word \code{target}
is defined generally in this case, encompassing imports
as well as true targets.
If \code{targets} is \code{NULL}, everything in the
cache is rescued.}

\item{path}{Character, either the root file path of a \code{drake} project
or a folder containing the root (top-level working directory
where you plan to call \code{\link[=make]{make()}}).
If this is too confusing, feel free to just use \code{storr::storr_rds()}
to get the cache.
If \code{search = FALSE}, \code{path} must be the root.
If \code{search = TRUE}, you can specify any
subdirectory of the project. Let's say \code{"/home/you/my_project"}
is the root. The following are equivalent and correct:
\itemize{
\item \code{get_cache(path = "/home/you/my_project", search = FALSE)}
\item \code{get_cache(path = "/home/you/my_project", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/subdir/x", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/.drake", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/.drake/keys", search = TRUE)}
}}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{force}{Deprecated.}

\item{cache}{A \code{storr} cache object.}

\item{jobs}{Number of jobs for light parallelism
(disabled on Windows).}

\item{garbage_collection}{Logical, whether to do garbage collection
as a final step. See \code{\link[=drake_gc]{drake_gc()}} and \code{\link[=clean]{clean()}}
for details.}
}
\value{
The rescued drake/storr cache.
}
\description{
Sometimes, \code{storr} caches may have
dangling orphaned files that prevent you from loading or cleaning.
This function tries to remove those files so you can use the
cache normally again.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build targets. This creates the cache.
# Remove dangling cache files that could cause errors.
rescue_cache(jobs = 2)
# Alternatively, just rescue targets 'small' and 'large'.
# Rescuing specific targets is usually faster.
rescue_cache(targets = c("small", "large"))
}
})
}
}
\seealso{
\code{\link[=get_cache]{get_cache()}}, \code{\link[=cached]{cached()}},
\code{\link[=drake_gc]{drake_gc()}}, \code{\link[=clean]{clean()}}
}
