% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_runtime.R
\name{predict_workers}
\alias{predict_workers}
\title{Predict the load balancing of the next call to \code{make()}
for non-staged parallel backends.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
predict_workers(
  ...,
  targets_predict = NULL,
  from_scratch = FALSE,
  targets_only = NULL,
  jobs_predict = 1L,
  known_times = numeric(0),
  default_time = 0,
  warn = TRUE,
  config = NULL
)
}
\arguments{
\item{...}{Arguments to \code{\link[=make]{make()}}, such as \code{plan} and \code{targets}.}

\item{targets_predict}{Character vector, names of targets
to include in the total runtime and worker predictions.}

\item{from_scratch}{Logical, whether to predict a
\code{\link[=make]{make()}} build from scratch or to
take into account the fact that some targets may be
already up to date and therefore skipped.}

\item{targets_only}{Deprecated.}

\item{jobs_predict}{The \code{jobs} argument of your next planned
\code{make()}.}

\item{known_times}{A named numeric vector with targets/imports
as names and values as hypothetical runtimes in seconds.
Use this argument to overwrite any of the existing build times
or the \code{default_time}.}

\item{default_time}{Number of seconds to assume for any
target or import with no recorded runtime (from \code{\link[=build_times]{build_times()}})
or anything in \code{known_times}.}

\item{warn}{Logical, whether to warn the user about
any targets with no available runtime, either in
\code{known_times} or \code{\link[=build_times]{build_times()}}. The times for these
targets default to \code{default_time}.}

\item{config}{Deprecated.}
}
\value{
A data frame showing one likely arrangement
of targets assigned to parallel workers.
}
\description{
Take the past recorded runtimes times from
\code{\link[=build_times]{build_times()}} and use them to predict how the targets
will be distributed among the available workers in the
next \code{\link[=make]{make()}}.
Predictions only include the time it takes to run the targets,
not overhead/preprocessing from \code{drake} itself.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
known_times <- rep(7200, nrow(my_plan))
names(known_times) <- my_plan$target
known_times
# Predict the runtime
if (requireNamespace("lubridate", quietly = TRUE)) {
predict_runtime(
  my_plan,
  jobs_predict = 7L,
  from_scratch = TRUE,
  known_times = known_times
)
predict_runtime(
  my_plan,
  jobs_predict = 8L,
  from_scratch = TRUE,
  known_times = known_times
)
balance <- predict_workers(
  my_plan,
  jobs_predict = 7L,
  from_scratch = TRUE,
  known_times = known_times
)
balance
}
}
})
}
}
\seealso{
\code{\link[=predict_runtime]{predict_runtime()}}, \code{\link[=build_times]{build_times()}}, \code{\link[=make]{make()}}
}
