% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_correctOne.R
\name{dr_correctOne}
\alias{dr_correctOne}
\title{One-point drift correction}
\usage{
dr_correctOne(.data, sourceVar, cleanVar, calVal, calStd, factorVar)
}
\arguments{
\item{.data}{A tbl}

\item{sourceVar}{Name of variable to correct}

\item{cleanVar}{New variable name for corrected data}

\item{calVal}{A numeric value; the value that the instrument was actually reading for the parameter}

\item{calStd}{A numeric value; the value that the instrument should have been reading for that
standard; i.e. the standard value}

\item{factorVar}{Name of variable generated using \code{\link{dr_factor}}}
}
\value{
An object of the same class as \code{.data} with the new corrected variable added
to the other data in \code{.data}.
}
\description{
A wrapper around \code{dplyr::mutate()} that creates a corrected value for each observation of the
    specified variable based on one data point.
}
\details{
This function takes the raw data from the water-quality instrument, utilizes the values generated from
    \code{\link{dr_factor}} and returns data that accounts for drift over time. This is done via a one-point
    calibration standard, which it typical for specific conductivity, dissolved oxygen, and turbidity.
}
\examples{
testData <- data.frame(
   Date = c("9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015"),
   Time = c("12:10:49", "12:15:50", "12:20:51", "12:25:51", "12:30:51", "12:35:51"),
   Temp = c(14.76, 14.64, 14.57, 14.51, 14.50, 14.63),
   SpCond = c(0.754, 0.750, 0.750, 0.749, 0.749, 0.749),
   corrFac = c(0.0000000, 0.2003995, 0.4007989, 0.6005326, 0.8002663, 1.0000000),
   stringsAsFactors = FALSE
 )

dr_correctOne(testData, sourceVar = SpCond, cleanVar = SpCond_Corr,
    calVal = 1.05, calStd = 1, factorVar = corrFac)

}
\seealso{
\code{\link{dr_factor}} for correction factor creation,
    \code{\link{dr_correctTwo}} for the two-point drift correction
}
