% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_cohort_features_table}
\alias{example_cohort_features_table}
\title{Example Cohort-level Features Table for Driver Prioritization}
\format{
A data frame with 349 rows and 27 variables:
\describe{
\item{gene_symbol}{HGNC gene symbol}
\item{metaprediction_score}{the maximum metapredictor (coding) impact score for the gene}
\item{noncoding_score}{the maximum non-coding PHRED-scaled CADD score for the gene}
\item{scna_score}{SCNA proxy score. SCNA density (SCNA/Mb) of the minimal common region (MCR) in which the gene is located}
\item{hotspot_double_hit}{boolean indicating whether the gene is a hotspot gene (indication of oncogenes) or subject to double-hit (indication of tumor-suppressor genes)}
\item{phenolyzer_score}{'phenolyzer' score for the gene}
\item{hsa03320}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04010}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04020}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04024}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04060}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04066}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04110}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04115}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04150}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04151}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04210}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04310}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04330}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04340}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04350}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04370}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04510}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04512}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04520}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04630}{boolean indicating whether or not the gene takes part in this KEGG pathway}
\item{hsa04915}{boolean indicating whether or not the gene takes part in this KEGG pathway}
}
}
\usage{
example_cohort_features_table
}
\description{
The example dataset containing features for prioritizing cancer driver genes for 10 randomly
selected samples from TCGA's LAML (Acute Myeloid Leukemia) cohort
}
\seealso{
\code{\link{KEGG_cancer_pathways_descriptions}} for descriptions of
KEGG "Pathways in cancer"-related pathways.
}
\keyword{datasets}
