% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiple_tte.R
\name{pgo_multiple_tte}
\alias{pgo_multiple_tte}
\title{Probability to go to phase III for multiple endpoints in the time-to-event setting}
\usage{
pgo_multiple_tte(HRgo, n2, hr1, hr2, id1, id2, fixed, rho)
}
\arguments{
\item{HRgo}{threshold value for the go/no-go decision rule;}

\item{n2}{total sample size for phase II; must be even number}

\item{hr1}{assumed true treatment effect on HR scale for endpoint OS}

\item{hr2}{assumed true treatment effect on HR scale for endpoint PFS}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{fixed}{choose if true treatment effects are fixed or random}

\item{rho}{correlation between the two endpoints}
}
\value{
The output of the function \code{pgo_multiple_tte()} is the probability to go to phase III.
}
\description{
This function calculates the probability that we go to phase III, i.e. that results of phase II are promising enough to
get a successful drug development program. Successful means that at least one endpoint shows a statistically significant positive treatment effect in phase III.
}
\keyword{internal}
