% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{diff_times}
\alias{diff_times}
\title{Get the difference between two times (in human units).}
\usage{
diff_times(from_time, to_time = Sys.time(), unit = "days", as_character = TRUE)
}
\arguments{
\item{from_time}{From time (required, scalar or vector, as "POSIXct"). 
Origin time, assumed to be of class "POSIXct", 
and coerced into "POSIXct" when of class "Date" or "POSIXlt.}

\item{to_time}{To time (optional, scalar or vector, as "POSIXct"). 
Default: \code{to_time = Sys.time()}. 
Maximum time, assumed to be of class "POSIXct", 
and coerced into "POSIXct" when of class "Date" or "POSIXlt".}

\item{unit}{Largest measurement unit for representing results. 
Units represent human time periods, rather than 
chronological time differences. 
Default: \code{unit = "days"} for completed days, hours, minutes, and seconds. 
Options available: 
\enumerate{

  \item \code{unit = "years"}: completed years, months, and days (default)
  
  \item \code{unit = "months"}: completed months, and days
  
  \item \code{unit = "days"}: completed days
  
  \item \code{unit = "hours"}: completed hours 
  
  \item \code{unit = "minutes"}: completed minutes
  
  \item \code{unit = "seconds"}: completed seconds
  
  }
Units may be abbreviated.}

\item{as_character}{Boolean: Return output as character? 
Default: \code{as_character = TRUE}.  
If \code{as_character = FALSE}, results are returned 
as columns of a data frame 
and include \code{from_date} and \code{to_date}.}
}
\value{
A character vector or data frame 
(with times, sign, and numeric columns for units).
}
\description{
\code{diff_times} computes the difference between two times 
(i.e., from some \code{from_time} to some \code{to_time}) 
in human measurement units (periods).
}
\details{
\code{diff_times} answers questions like 
"How much time has elapsed between two dates?" 
or "How old are you?" in human time periods 
of (full) years, months, and days. 

Key characteristics:

\itemize{

  \item If \code{to_time} or \code{from_time} are not "POSIXct" objects, 
  \code{diff_times} aims to coerce them into "POSIXct" objects. 

  \item If \code{to_time} is missing (i.e., \code{NA}), 
  \code{to_time} is set to the current time (i.e., \code{Sys.time()}).
  
  \item If \code{to_time} is specified, any intermittent missing values 
  (i.e., \code{NA}) are set to the current time (i.e., \code{Sys.time()}). 

  \item If \code{to_time} precedes \code{from_time} (i.e., \code{from_time > to_time}) 
  computations are performed on swapped times and the result is marked 
  as negative (by a character \code{"-"}) in the output.

  \item If the lengths of \code{from_time} and \code{to_time} differ, 
  the shorter vector is recycled to the length of the longer one. 

}

By default, \code{diff_times} provides output as (signed) character strings. 
For numeric outputs, use \code{as_character = FALSE}.
}
\examples{
t1 <- as.POSIXct("1969-07-13 13:53 CET")  # (before UNIX epoch)
diff_times(t1, unit = "years", as_character = TRUE)
diff_times(t1, unit = "secs", as_character = TRUE)

}
\seealso{
\code{\link{diff_dates}} for date differences;  
time spans (an \code{interval} \code{as.period}) in the \strong{lubridate} package.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
