% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comperr.R
\name{dcomperr}
\alias{dcomperr}
\alias{pcomperr,}
\alias{qcomperr,}
\alias{rcomperr}
\alias{pcomperr}
\alias{qcomperr}
\title{Composed error term distribution}
\usage{
dcomperr(
  x = 0,
  mu = 0,
  sigma_v = 1,
  par_u = 1,
  s = -1,
  family = "normhnorm",
  deriv = 0,
  tri = NULL,
  log.p = FALSE
)

pcomperr(
  q,
  mu = 0,
  sigma_v = 1,
  par_u = 1,
  s = -1,
  family = "normhnorm",
  deriv = 0,
  tri = NULL,
  lower.tail = TRUE,
  log.p = FALSE
)

qcomperr(
  p,
  mu = 0,
  sigma_v = 1,
  par_u = 1,
  s = -1,
  family = "normhnorm",
  lower.tail = TRUE,
  log.p = FALSE
)

rcomperr(n, mu = 0, sigma_v = 1, par_u = 1, s = -1, family = "normhnorm")
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu}{vector of \eqn{\mu}}

\item{sigma_v}{vector of \eqn{\sigma_V}. Must be positive.}

\item{par_u}{vector of parameter of the (in)efficiency term. Must be positive.}

\item{s}{\eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{family}{\eqn{normhnorm} for normal-halfnormal and \eqn{normexp} for normal-exponential distribution.}

\item{deriv}{derivative of order \code{deriv} of the log density. Available are \code{0},\code{2} and \code{4}.}

\item{tri}{optional, index arrays for upper triangular matrices, generated by \code{\link[mgcv:trind.generator]{trind.generator()}} and supplied to \code{chainrule()}.}

\item{log.p}{logical; if \code{TRUE}, probabilities p are given as \code{log(p)}.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}  otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dcomperr} gives the density, \code{pcomperr} gives the distribution function, \code{qcomperr} gives the quantile function, and \code{rcomperr} generates random numbers, with given parameters. If the derivatives are calculated these are provided as the attributes \code{gradient}, \code{hessian}, \code{l3} and \code{l4} of the output of the density.
}
\description{
Probablitiy density function, distribution, quantile function and random number generation for the composed error term distribution.
}
\details{
This is wrapper function for the normal-halfnormal and normal-exponential distribution. A random variable \eqn{\mathcal{E}} follows a composed error distribution if \eqn{\mathcal{E} = V + s \cdot U }, where \eqn{V \sim N(\mu, \sigma_V^2)} and \eqn{U \sim HN(0,\sigma_U^2)} or \eqn{U \sim Exp(0,\sigma_U^2)}.
For more details see \code{dnormhnorm} and \code{dnormexp}. Here, \eqn{s=-1} for production and \eqn{s=1} for cost function.
}
\section{Functions}{
\itemize{
\item \code{pcomperr()}: distribution function for the composed error distribution.

\item \code{qcomperr()}: quantile function for the composed error distribution.

\item \code{rcomperr()}: random number generation for the composed error distribution.

}}
\examples{
pdf <- dcomperr(x=seq(-3, 3, by=0.1), mu=1, sigma_v=2, par_u=3, s=-1, family="normhnorm")
cdf <- pcomperr(q=seq(-3, 3, by=0.1), mu=1, sigma_v=2, par_u=3, s=-1, family="normhnorm")
q <- qcomperr(p=seq(0.1, 0.9, by=0.1), mu=1, sigma_v=2, par_u=3, s=-1, family="normhnorm")
r <- rcomperr(n=100, mu=1, sigma_v=2, par_u=3, s=-1, family="normhnorm")

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
\item \insertRef{gradshteyn2014table}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
}
}
