% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cop_mgcv.R
\name{cop}
\alias{cop}
\title{cop family}
\usage{
cop(link = list("glogit"), W, family_cop = "normal")
}
\arguments{
\item{link}{specifying the link for the \eqn{\delta}.}

\item{W}{matrix of pseudo observations. Must have at least two columns.}

\item{family_cop}{string, defines the copula family:\cr
\code{independent} = Independence copula \cr
\code{normal} = Gaussian copula \cr
\code{clayton} = Clayton copula \cr
\code{gumbel} = Gumbel copula \cr
\code{frank} = Frank copula \cr
\code{joe} = Joe copula \cr}
}
\value{
An object inheriting from class \code{general.family} of the mgcv package, which can be used in the dsfa package.
}
\description{
The cop family implements multiple copula distributions in which the \eqn{\delta} can depend on additive predictors. Useable only with \code{\link[mgcv:gam]{gam()}}, the additive predictors is specified via a formulae.
}
\details{
Internal function. Used with gam to fit copula model, which in turn is used for starting values. The function \code{gam} is from the mgcv package is called with a formula.
The formula specifies the a dummy on the left hand side and the structure of the additive predictor for \eqn{\delta} parameter on the right hand side. Link function is "generalized logit", where for each family_cop argument there are specific \code{a} and \code{b} arguments, which are the boundaries of the parameter space. Although the parameter space is
larger in theory, numeric under- and overflow limit the parameter space.
\enumerate{
\item  \code{independent}, a=0 and b=1
\item  \code{normal}, a=-1 and b=1
\item  \code{clayton}, a=1e-16 and b=28
\item  \code{gumbel}, a=1 and b=17
\item  \code{frank}, a=-35 and b=35
\item  \code{joe}, a=1e-16 and b=30
}
}
\examples{
\donttest{
set.seed(1337)
N=1000 #Sample size
x1<-runif(N,-1,1)
eta<-1+2.5*x1
delta<-rsp(x=eta, link="glogit", a=-1, b=1)
dat<-as.data.frame(rcop(n=N, delta=delta, family="normal"))
dat$y<-1
model<-mgcv::gam(y~x1, data=dat,
                 family=cop(W=as.matrix(dat[,1:2, drop=FALSE]), family_cop="normal"),
                 optimizer="efs")
}

}
\keyword{internal}
