% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axeslabel.R
\name{xlabel}
\alias{xlabel}
\title{Create a label on the x-axis}
\usage{
xlabel(label = "", line = 3, ...)
}
\arguments{
\item{label}{The title of the axis, to be displayed on image. Text can be input in the form of pseudo-LaTeX code within quotes.
See \code{\link[latex2exp]{TeX}} for more details.}

\item{line}{The distance from the axis the text will be displayed.}

\item{...}{Extra parameters. These parameters are fed into \code{mtext()}.}
}
\description{
Labels the x-axis
}
\examples{
 library(dsmodels)
 fun <- function(X,Y) {
 list(
     X/exp(Y),
     Y/exp(X)
  )
}

model <- dsmodel(fun, title = "Cool Function!")
model + dsrange(-2:3,-2:3, discretize = .09) +
 xlabel("X-Axis shows $\\\\alpha$!") +
 ylabel("Y-Axis shows $\\\\beta$!")
}
\seealso{
\code{\link[latex2exp]{TeX}}
}
