% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot-dtwSat.R
\name{plotClassify}
\alias{plotClassify}
\title{Plotting classification of dtwSat object}
\usage{
plotClassify(x, attr = NULL, ...)
}
\arguments{
\item{x}{An \code{\link[dtwSat]{dtwSat-class}} object}

\item{attr}{A vector of integer or a character indicating
the attribute for plotting, \emph{i.e.} the column of the \code{query}.
Default is 1}

\item{...}{additional arguments passed to \code{\link[dtwSat]{classfyIntervals}}}
}
\value{
object of class \link[ggplot2]{ggplot}
}
\description{
Method for plotting the classification of
time intervals
}
\examples{
malig = mtwdtw(query.list, template, weight = "logistic",
               alpha = 0.1, beta = 100)

gp = plotClassify(x=malig, attr=c("ndvi","evi"), from=as.Date("2009-09-01"),
             to=as.Date("2013-09-01"), by = "6 month",
             normalized=TRUE, overlap=.7)
gp
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat}}, \code{\link[dtwSat]{plotPath}},
\code{\link[dtwSat]{plotAlignment}}, and \code{\link[dtwSat]{plotCostMatrix}}
}

