% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtwclust-plot.R
\docType{methods}
\name{plot-dtwclust}
\alias{plot,dtwclust,missing-method}
\alias{plot-dtwclust}
\title{Plot the result of \code{dtwclust}}
\usage{
\S4method{plot}{dtwclust,missing}(x, y, ..., clus = seq_len(x@k),
  labs.arg = NULL, data = NULL, time = NULL, plot = TRUE)
}
\arguments{
\item{x}{An object of class \code{\link{dtwclust-class}} as returned by \code{\link{dtwclust}}.}

\item{y}{Ignored.}

\item{...}{Further arguments to pass to \code{\link[ggplot2]{geom_line}} for the plotting of the
\emph{cluster centers}. Default values are: \code{linetype = "dashed"}, \code{size = 1.5},
\code{colour = "black"}, \code{alpha = 0.5}.}

\item{clus}{A numeric vector indicating which clusters to plot.}

\item{labs.arg}{Arguments to change the title and/or axis labels. See \code{\link[ggplot2]{labs}} for more
information}

\item{data}{The data in the same format as it was provided to \code{\link{dtwclust}}.}

\item{time}{Optional values for the time axis. If series have different lengths, provide the time values of
the longest series.}

\item{plot}{Logical flag. You can set this to \code{FALSE} in case you want to save the ggplot object without
printing anything to screen}
}
\value{
A \code{gg} object invisibly.
}
\description{
Plots the time series of each cluster along with the obtained centroid. It uses \code{ggplot2} plotting
system.
}
\details{
The flag \code{save.data} should be set to \code{TRUE} when running \code{\link{dtwclust}} to be able to
use this. Optionally, you can manually provide the data in the \code{data} parameter.

The function returns the \code{gg} object invisibly, in case you want to modify it to your liking. You
might want to look at \code{\link[ggplot2]{ggplot_build}} if that's the case.
}
\seealso{
\code{\link{dtwclust-class}}, \code{\link{dtwclust}}, \code{\link[ggplot2]{ggplot}}
}

