context("\tCentroids")

# =================================================================================================
# setup
# =================================================================================================

## Original objects in env
ols <- ls()

# =================================================================================================
# centroids
# =================================================================================================

with(persistent, {
    test_that("Centroid calculations give the same results as references.", {
        skip_on_cran()

        expect_equal_to_reference(dba2_uv, file_name(dba2_uv), info = "DBAv2 Univariate")
        expect_equal_to_reference(dba2_mv, file_name(dba2_mv), info = "DBAv2 Multivariate")
    })
})

# =================================================================================================
# clean
# =================================================================================================
rm(list = setdiff(ls(), ols))
