% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtwclust-methods.R
\docType{methods}
\name{dtwclust-methods}
\alias{dtwclust-methods}
\alias{show,dtwclust-method}
\alias{show,dtwclust}
\alias{update.dtwclust}
\alias{update,dtwclust-method}
\alias{update,dtwclust}
\alias{predict.dtwclust}
\alias{predict,dtwclust-method}
\alias{predict,dtwclust}
\alias{plot.dtwclust}
\alias{plot,dtwclust,missing-method}
\alias{plot,dtwclust,missing}
\title{Methods for \code{dtwclust}}
\usage{
\S4method{show}{dtwclust}(object)

\method{update}{dtwclust}(object, ..., evaluate = TRUE)

\S4method{update}{dtwclust}(object, ..., evaluate = TRUE)

\method{predict}{dtwclust}(object, newdata = NULL, ...)

\S4method{predict}{dtwclust}(object, newdata = NULL, ...)

\method{plot}{dtwclust}(x, y, ..., clus = seq_len(x@k), labs.arg = NULL,
  data = NULL, time = NULL, plot = TRUE, type = NULL)

\S4method{plot}{dtwclust,missing}(x, y, ..., clus = seq_len(x@k),
  labs.arg = NULL, data = NULL, time = NULL, plot = TRUE, type = NULL)
}
\arguments{
\item{object, x}{An object of class \linkS4class{dtwclust} as returned by \code{\link[=dtwclust]{dtwclust()}}.}

\item{...}{For \code{plot}, further arguments to pass to \code{\link[ggplot2:geom_line]{ggplot2::geom_line()}} for the plotting of
the \emph{cluster centroids}, or to \code{\link[stats:plot.hclust]{stats::plot.hclust()}}. See details. For \code{update}, any supported
argument. Otherwise ignored.}

\item{evaluate}{Logical. Defaults to \code{TRUE} and evaluates the updated call, which will result in
a new \code{dtwclust} object. Otherwise, it returns the unevaluated call.}

\item{newdata}{New data to be assigned to a cluster. It can take any of the supported formats of
\code{\link[=dtwclust]{dtwclust()}}. Note that for multivariate series, this means that it \strong{must} be a list of
matrices, even if the list has only one element.}

\item{y}{Ignored.}

\item{clus}{A numeric vector indicating which clusters to plot.}

\item{labs.arg}{Arguments to change the title and/or axis labels. See \code{\link[ggplot2:labs]{ggplot2::labs()}} for more
information}

\item{data}{Optionally, the data in the same format as it was provided to \code{\link[=dtwclust]{dtwclust()}}.}

\item{time}{Optional values for the time axis. If series have different lengths, provide the time
values of the longest series.}

\item{plot}{Logical flag. You can set this to \code{FALSE} in case you want to save the ggplot object
without printing anything to screen}

\item{type}{What to plot. \code{NULL} means default. See details.}
}
\description{
\strong{Deprecated} methods associated with \linkS4class{dtwclust} objects.
}
\details{
Please refer to \link{tsclusters-methods} for the updated versions.
}
\keyword{internal}
