#' @name dual.spls-package
#' @docType package
#' @title dual.spls package
#'
#' @description
#' This package provides a series of functions that compute latent sparse components used in a regression model.
#' These components are based on a generalization of the classical PLS1 algorithm i.e. for a one dimensionnal response.
#' Denoting \eqn{\Omega(w)=\|w\|_2} the euclidian norm, the PLS1 algorithm amounts to finding the vector \eqn{w} involved in the evaluation of the dual norm
#' \deqn{\Omega^*(z)=\max_w(z^Tw) \textrm{ s.t. } \Omega(w)=1,} where \eqn{z=X^Ty},
#' \eqn{X} is the matrix of predictors and \eqn{y} is the response vector.
#' This problem is reformulated as follows
#'  \deqn{\Omega^*(z)=\min_{w,\mu}(-z^Tw)+\mu(\Omega(w)-1),}
#' where \eqn{\mu} is the lagragian multiplier. The resulting solution \eqn{w} is colinear to the coefficients vector.
#'
#' The PLS1 algorithm is then extended by varying the underlying norm \eqn{\Omega(w)} and notably including some
#'  penalization that leads to sparse regression coefficients for variable selection. For more details refer to (ref). The available norms considered are:
#' \itemize{
#' \item PLS1: \eqn{\Omega(w)= \|w\|_2},
#' \item Lasso: \eqn{\Omega(w)=\lambda \|w\|_1 + \|w\|_2} where \eqn{\lambda} is a positive scalar,
#' \item Group Lasso with 3 possible norms; for \eqn{G} the number of groups and \eqn{\alpha_g}, \eqn{\lambda_g} and \eqn{\gamma_g} all positive scalars,
#' \itemize{
#' \item Norm A *(generalized norm)*: \eqn{\Omega_g(w)=\|w_g\|_2+ \lambda_g \|w_g\|_1} where
#' \eqn{\Omega(w)=\sum_{g} \alpha_g \Omega_g(w)=1 \textrm{ and } \sum_{g=1}^G \alpha_g=1},
#
#' \item Norm B *(particular case)*: \eqn{\Omega(w)=\|w\|_2+\sum_{g=1}^G \lambda_g\|w_g\|_1},
#'
#' \item Norm C *(particular case)*: \eqn{\Omega(w)=\sum_{g=1}^G \alpha_g \|w \|_2+\sum_{g=1}^G \lambda_g \|w_g \|_1}
#'  where
#' \eqn{\sum_{g=1}^G \alpha_g=\sum_{g=1}^G \gamma_g=1} \cr and \eqn{\Omega(w_g)=\gamma_g}.
#' }
#' \item Least Squares: \eqn{\Omega(w)=\lambda \|N_1w\|_1 + \|Xw\|_2} where \eqn{N_1} is a matrix and \eqn{\lambda} is a positive scalar,
#' \item Ridge: \eqn{\Omega(w)=\lambda_1 \|w\|_1 +\lambda_2 \|Xw\|_2 + \|w\|_2} where \eqn{\lambda_1} and \eqn{\lambda_2} are both positive scalars.
#' }
#' This package also suggests \itemize{
#' \item a calibration and validation method called CalValXy based on a modified version of the Kennard
#'  and Stone Algorithm (ref),
#'\item a function that simulates data composed of Gaussian mixtures,
#'\item a function that chooses the number of components according to the cross validation procedure,
#'\item a series of functions that display results and help in the interpretations.
#'\item a real data representing 208 near infrared spectra of refined petroleum sapmles with their density (ref).
#'}
#' @author Louna Alsouki François Wahl
#' @seealso [dual.spls::d.spls.lasso], [dual.spls::d.spls.LS], [dual.spls::d.spls.ridge],
#' [dual.spls::d.spls.GL]
#'
#' @importFrom pdist pdist
#' @importFrom stats rnorm
#' @importFrom stats runif
#' @importFrom stats prcomp
#' @importFrom graphics points
#' @importFrom graphics par
#' @importFrom graphics legend
#' @importFrom graphics plot
#'
"_PACKAGE"
