% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.spls.GLA.R
\name{d.spls.GLA}
\alias{d.spls.GLA}
\title{Dual Sparse Partial Least Squares (Dual-SPLS) regression for the group lasso norm A}
\usage{
d.spls.GLA(X, y, ncp, ppnu, indG, verbose = FALSE)
}
\arguments{
\item{X}{a numeric matrix of predictors values of dimension \code{(n,p)}. Each row represents one observation and each column one predictor variable.}

\item{y}{a numeric vector or a one column matrix of responses. It represents the response variable for each observation.}

\item{ncp}{a positive integer. \code{ncp} is the number of Dual-SPLS components.}

\item{ppnu}{a positive real value or a vector of length the number of groups, in \eqn{[0,1]}.
\code{ppnu} is the desired proportion of variables to shrink to zero for each component and for each group.}

\item{indG}{a numeric vector of group index for each observation.}

\item{verbose}{a Boolean value indicating whether or not to display the iterations steps.}
}
\value{
A \code{list} of the following attributes
\item{Xmean}{the mean vector of the predictors matrix \code{X}.}
\item{scores}{the matrix of dimension \code{(n,ncp)} where \code{n} is the number of observations. The \code{scores} represents
the observations in the new component basis computed by the compression step
of the Dual-SPLS.}
\item{loadings}{the matrix of dimension \code{(p,ncp)} that represents the Dual-SPLS components.}
\item{Bhat}{the matrix of dimension \code{(p,ncp)} that regroups the regression coefficients for each component.}
\item{intercept}{the vector of length \code{ncp} representing the intercept values for each component.}
\item{fitted.values}{the matrix of dimension \code{(n,ncp)} that represents the predicted values of \code{y}}
\item{residuals}{the matrix of dimension \code{(n,ncp)} that represents the residuals corresponding
to the difference between the responses and the fitted values.}
\item{lambda}{the matrix of dimension \code{(G,ncp)} collecting the parameters of sparsity \eqn{\lambda_g} used to fit the model at each iteration and for each group.}
\item{alpha}{the matrix of dimension \code{(G,ncp)} collecting the constraint parameters \eqn{\alpha_g}  used to fit the model at each iteration and for each group.}
\item{zerovar}{the matrix of dimension \code{(G,ncp)} representing the number of variables shrank to zero per component and per group.}
\item{PP}{the vector of length \code{G} specifying the number of variables in each group.}
\item{ind_diff0}{the list of \code{ncp} elements representing the index of the none null regression coefficients elements.}
\item{type}{a character specifying the Dual-SPLS norm used. In this case it is \code{GLA}. }
}
\description{
The function \code{d.spls.GLA} performs dimensional reduction as in PLS methodology combined to variable selection using the
Dual-SPLS algorithm with the norm \deqn{\Omega_g(w)=\|w_g\|_2+ \lambda_g \|w_g\|_1} for combined data where
\eqn{\Omega(w)=\sum_{g=1}{^G} \alpha_g \Omega_g(w)=1};
\eqn{\sum_{g=1}^G \alpha_g=1} and \code{G} is the number of groups.
Dual-SPLS for the group lasso norms has been designed to confront the situations where the predictors
variables can be divided in distinct meaningful groups. Each group is constrained by an independent
threshold as in the dual sparse lasso methodology,
that is each \eqn{w_g} will be collinear to a vector \eqn{z.\nu_g} built from the coordinate of \eqn{z}
and constrained by the threshold \eqn{\nu_g}. Norm A i a generalized group lasso-like norm that applies the lasso norm for each group individually while constraining the overall norm. Moreover,
the Euclidian norm of each \eqn{w_g} is computed while minimizing the root mean squares error of prediction.
}
\seealso{
\link{d.spls.GLA},\link{d.spls.GLB},\link{d.spls.GL}
}
\author{
Louna Alsouki François Wahl
}
\keyword{internal}
