% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findUndisputed.R
\name{findUndisputed}
\alias{findUndisputed}
\title{Undisputed identifications in a DVI problem}
\usage{
findUndisputed(
  dvi,
  pairings = NULL,
  ignoreSex = FALSE,
  threshold = 10000,
  relax = FALSE,
  limit = 0,
  nkeep = NULL,
  check = TRUE,
  numCores = 1,
  verbose = TRUE
)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{pairings}{A list of possible pairings for each victim. If NULL, all
sex-consistent pairings are used.}

\item{ignoreSex}{A logical.}

\item{threshold}{A non-negative number. If no pairwise LR exceed this, the
iteration stops.}

\item{relax}{A logical affecting the definition of being undisputed (see
Details). Default: FALSE.}

\item{limit}{A positive number. Only pairwise LR values above this are
considered.}

\item{nkeep}{An integer, or NULL. If given, only the \code{nkeep} most likely
pairings are kept for each victim.}

\item{check}{A logical indicating if the input data should be checked for
consistency. Default: TRUE.}

\item{numCores}{An integer; the number of cores used in parallelisation.
Default: 1.}

\item{verbose}{A logical. Default: TRUE.}
}
\value{
A list with the following entries:
\itemize{
\item \code{undisputed}: A data frame containing the undisputed matches, including LR.
\item \code{dviReduced}: A reduced version of \code{dvi}, where undisputed
victims/missing persons are removed, and data from undisputed victims
inserted in \code{am}.
\item \code{LRmatrix}, \code{LRlist}, \code{pairings}: Output from \code{pairwiseLR()} applied to
the reduced problem.
}
}
\description{
This function uses the pairwise LR matrix to find "undisputed" matches
between victims and missing individuals. An identification \eqn{V_i = M_j} is
called undisputed if the corresponding likelihood ratio \eqn{LR_{i,j}}
exceeds the given \code{threshold}, while all other pairwise LRs involving
\eqn{V_i} or \eqn{M_j} are at most 1.
}
\details{
If the parameter \code{relax} is set to TRUE, the last criterion is relaxed,
requiring instead that \eqn{LR_{i,j}} is at least \code{threshold} times greater
than all other pairwise LRs involving \eqn{V_i} or \eqn{M_j}
}
\examples{

\donttest{
findUndisputed(planecrash, threshold = 1e4)

# With `relax = TRUE`, one more identification is undisputed
findUndisputed(planecrash, threshold = 1e4, relax = TRUE)
}

}
\seealso{
\code{\link[=pairwiseLR]{pairwiseLR()}}, \code{\link[=findExcluded]{findExcluded()}}
}
