% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cov_i}
\alias{cov_i}
\title{Sample Covariance for Integer Vectors}
\usage{
cov_i(x, y)
}
\arguments{
\item{x, y}{Integer vector.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[stats]{cov}} for integer vectors. Will give incorrect result for 
non-integer vectors, and does not check that \code{x} and \code{y} are 
same length or that they contain no missing values.
}
\examples{
# For integer vectors, cov_i is typically much faster than cov.
x <- rpois(1000, lambda = 5)
y <- rpois(1000, lambda = 5)
all.equal(cov(x, y), cov_i(x, y))
benchmark(cov(x, y), cov_i(x, y), replications = 5000)

}
