% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quant_groups.R
\name{quant_groups}
\alias{quant_groups}
\title{Split Continuous Variable into Quantile Groups}
\usage{
quant_groups(x, groups = 5, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{groups}{Numeric value indicating how many quantile groups should be 
created.}

\item{...}{Further arguments to pass to \code{\link[stats]{quantile}} or \code{\link{cut}}.}
}
\value{
Factor variable.
}
\description{
Splits a continuous variable into quantiles groups. Basically combines 
\code{\link[stats]{quantile}} and \code{\link[base]{cut}} into a single 
function.
}
\examples{
# Convert values from N(0, 1) into quintiles (i.e. 5 groups)
x <- rnorm(1000)
groups <- quant_groups(x, 5)
table(groups)

}
