/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.button.RectangularButtonShaper;
import org.jvnet.substance.button.StandardButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.combo.SubstanceComboBoxButton;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.PairwiseButtonBackgroundDelegate;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.Sideable;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ButtonBackgroundDelegate {
    private static Map<String, BufferedImage> regularBackgrounds = new HashMap<String, BufferedImage>();
    private static WeakHashMap<AbstractButton, SubstanceConstants.ButtonTitleKind> titleButtons = new WeakHashMap();

    public static synchronized void reset() {
        regularBackgrounds.clear();
        PairwiseButtonBackgroundDelegate.reset();
    }

    public static synchronized void trackTitleButton(AbstractButton button, SubstanceConstants.ButtonTitleKind kind) {
        titleButtons.put(button, kind);
    }

    public static synchronized void untrackTitleButton(AbstractButton button) {
        titleButtons.remove(button);
    }

    public static synchronized SubstanceConstants.ButtonTitleKind getKind(AbstractButton button) {
        SubstanceConstants.ButtonTitleKind result = titleButtons.get(button);
        if (result == null) {
            result = SubstanceConstants.ButtonTitleKind.NONE;
        }
        return result;
    }

    public static synchronized ButtonBackground getBackground(AbstractButton button, SubstanceButtonShaper shaper, SubstanceGradientPainter painter, int width, int height) {
        ColorScheme colorScheme;
        JButton jb;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        boolean isPaintedActive = kind == ComponentState.ColorSchemeKind.CURRENT;
        float cyclePos = state.getCycleCount();
        boolean isPulsating = false;
        if (button instanceof JButton && PulseTracker.isPulsating(jb = (JButton)button) && state != ComponentState.PRESSED_SELECTED && state != ComponentState.PRESSED_UNSELECTED) {
            isPulsating = true;
            cyclePos = (int)(PulseTracker.getCycles(jb) % 20L);
            if (cyclePos > 10.0f) {
                cyclePos = 19.0f - cyclePos;
            }
            isPaintedActive = true;
        }
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getComponentTheme(button, kind).getColorScheme();
        SubstanceConstants.ButtonTitleKind buttonKind = ButtonBackgroundDelegate.getKind(button);
        boolean isWindowModified = false;
        if (buttonKind == SubstanceConstants.ButtonTitleKind.CLOSE || buttonKind == SubstanceConstants.ButtonTitleKind.CLOSE_DI) {
            for (Container comp = button; comp != null; comp = comp.getParent()) {
                if (comp instanceof JInternalFrame) {
                    JInternalFrame jif = (JInternalFrame)comp;
                    isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                    break;
                }
                if (comp instanceof JRootPane) {
                    JRootPane jrp = (JRootPane)comp;
                    isWindowModified = Boolean.TRUE.equals(jrp.getClientProperty("windowModified"));
                    break;
                }
                if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
                JInternalFrame.JDesktopIcon jdi = (JInternalFrame.JDesktopIcon)comp;
                JInternalFrame jif = jdi.getInternalFrame();
                isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                break;
            }
            if (isWindowModified) {
                colorScheme2 = SubstanceTheme.YELLOW;
                colorScheme = SubstanceTheme.ORANGE;
                isPaintedActive = true;
            }
        }
        if (!isWindowModified && !isPulsating) {
            ColorScheme defaultScheme;
            FadeTracker fadeTracker = FadeTracker.getInstance();
            if (fadeTracker.isTracked(button, FadeTracker.FadeKind.SELECTION)) {
                boolean isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(button);
                defaultScheme = SubstanceCoreUtilities.getDefaultScheme(button);
                if (state == ComponentState.DEFAULT) {
                    colorScheme = SubstanceCoreUtilities.getActiveScheme(button);
                    colorScheme2 = isActive ? colorScheme : defaultScheme;
                    cyclePos = 10.0f - fadeTracker.getFade10(button, FadeTracker.FadeKind.SELECTION);
                    isPaintedActive = true;
                }
                if (state == ComponentState.SELECTED) {
                    colorScheme2 = colorScheme;
                    colorScheme = isActive ? colorScheme : defaultScheme;
                    cyclePos = fadeTracker.getFade10(button, FadeTracker.FadeKind.SELECTION);
                    isPaintedActive = true;
                }
                if (SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.isToolbarButtonFlat(button) || SubstanceCoreUtilities.hasFlatProperty(button)) {
                    colorScheme2 = colorScheme = state.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(button) : SubstanceCoreUtilities.getDisabledScheme(button);
                }
            }
            if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
                boolean isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(button);
                defaultScheme = SubstanceCoreUtilities.getDefaultScheme(button);
                if (state == ComponentState.DEFAULT) {
                    colorScheme = SubstanceCoreUtilities.getActiveScheme(button);
                    colorScheme2 = isActive ? colorScheme : defaultScheme;
                    cyclePos = 10.0f - fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                }
                if (state == ComponentState.ROLLOVER_UNSELECTED) {
                    colorScheme2 = colorScheme;
                    colorScheme = isActive ? colorScheme : defaultScheme;
                    cyclePos = fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                }
                if (SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.isToolbarButtonFlat(button) || SubstanceCoreUtilities.hasFlatProperty(button)) {
                    colorScheme2 = colorScheme = state.isEnabled() ? SubstanceCoreUtilities.getActiveScheme(button) : SubstanceCoreUtilities.getDisabledScheme(button);
                }
                isPaintedActive = true;
            }
        }
        Set<SubstanceConstants.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonside");
        String straightKey = "";
        for (SubstanceConstants.Side sSide : straightSides) {
            straightKey = straightKey + sSide.name() + "-";
        }
        boolean isRoundButton = StandardButtonShaper.isRoundButton(button);
        float radius = 0.0f;
        if (shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, null);
        }
        Set<SubstanceConstants.Side> openSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonopenSide");
        String openKey = "";
        for (SubstanceConstants.Side oSide : openSides) {
            openKey = openKey + oSide.name() + "-";
        }
        String key = width + ":" + height + ":" + kind.name() + ":" + cyclePos + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + shaper.getClass().getName() + ":" + painter.getClass().getName() + ":" + straightKey + ":" + openKey + ":" + button.getClass().getName() + ":" + isRoundButton + ":" + radius;
        if (!regularBackgrounds.containsKey(key)) {
            int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? 3 : 0;
            int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? 3 : 0;
            int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? 3 : 0;
            int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? 3 : 0;
            GeneralPath contour = shaper.getButtonOutline(button, null, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom);
            BufferedImage contourBackground = painter.getContourBackground(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
            finalGraphics.drawImage((Image)contourBackground, -deltaLeft, -deltaTop, null);
            regularBackgrounds.put(key, newBackground);
        }
        return new ButtonBackground(isPaintedActive, regularBackgrounds.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackground(Graphics g, AbstractButton button) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        button.setOpaque(false);
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(button);
        try {
            Sideable sideable;
            JComboBox jc;
            int width = button.getWidth();
            int height = button.getHeight();
            int y = 0;
            if (button instanceof SubstanceComboBoxButton && (jc = (JComboBox)button.getParent()).getBorder() != null) {
                ++y;
                height -= 2;
            }
            if (SubstanceCoreUtilities.isScrollButton(button)) {
                sideable = (Sideable)((Object)button);
                PairwiseButtonBackgroundDelegate.updateBackground(g, button, sideable.getSide());
                return;
            }
            if (SubstanceCoreUtilities.isSpinnerButton(button)) {
                sideable = (Sideable)((Object)button);
                PairwiseButtonBackgroundDelegate.updateBackground(g, button, sideable.getSide());
                return;
            }
            SubstanceConstants.ButtonTitleKind buttonKind = ButtonBackgroundDelegate.getKind(button);
            if (buttonKind == SubstanceConstants.ButtonTitleKind.CLOSE_DI || buttonKind == SubstanceConstants.ButtonTitleKind.REGULAR_DI) {
                graphics.setComposite(AlphaComposite.getInstance(3, 0.8f));
            }
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
            ButtonBackground bb = ButtonBackgroundDelegate.getBackground(button, shaper, painter, width, height);
            BufferedImage bgImage = bb.backgroundImage;
            ControlBackgroundComposite composite = SubstanceCoreUtilities.getControlBackgroundComposite(button);
            BufferedImage result = SubstanceCoreUtilities.getBlankImage(bgImage.getWidth(), bgImage.getHeight());
            Graphics2D resultGr = result.createGraphics();
            resultGr.setComposite(composite.getBackgroundComposite(button, button.getParent(), -1, bb.isPaintedActive));
            BufferedImage temp = SubstanceCoreUtilities.getBlankImage(bgImage.getWidth(), bgImage.getHeight());
            Graphics2D tempGr = temp.createGraphics();
            try {
                if (SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.isToolbarButtonFlat(button) || SubstanceCoreUtilities.hasFlatProperty(button)) {
                    ComponentState state = ComponentState.getState(button.getModel(), button);
                    if (FadeTracker.getInstance().isTracked(button, FadeTracker.FadeKind.ROLLOVER) && !state.isSelected() && state.isEnabled()) {
                        float fadeCoef = FadeTracker.getInstance().getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                        tempGr.setComposite(AlphaComposite.getInstance(3, fadeCoef / 10.0f));
                    } else if (state == ComponentState.DEFAULT) {
                        return;
                    }
                    if (state != ComponentState.DISABLED_UNSELECTED) {
                        tempGr.drawImage((Image)bgImage, 0, 0, null);
                    }
                } else {
                    tempGr.drawImage((Image)bgImage, 0, 0, null);
                }
                resultGr.drawImage((Image)temp, 0, 0, null);
                graphics.drawImage((Image)result, 0, y, null);
            }
            finally {
                tempGr.dispose();
                resultGr.dispose();
            }
        }
        finally {
            graphics.dispose();
        }
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return false;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        GeneralPath contour = shaper.getButtonOutline(button);
        return contour.contains(x, y);
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + regularBackgrounds.size() + " regular");
        return sb.toString();
    }

    public static class ButtonBackground {
        public boolean isPaintedActive;
        public BufferedImage backgroundImage;

        public ButtonBackground(boolean isPaintedActive, BufferedImage backgroundImage) {
            this.isPaintedActive = isPaintedActive;
            this.backgroundImage = backgroundImage;
        }
    }
}

