/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractArc
extends EMFTag {
    private Rectangle bounds;
    private Point start;
    private Point end;

    protected AbstractArc(int id, int version, Rectangle bounds, Point start, Point end) {
        super(id, version);
        this.bounds = bounds;
        this.start = start;
        this.end = end;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writePOINTL(this.start);
        emf.writePOINTL(this.end);
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  start: " + this.start + "\n  end: " + this.end;
    }

    protected Shape getShape(EMFRenderer renderer, int arcType) {
        double alpha1;
        double alpha0;
        double nx0 = this.start.getX() / this.bounds.getWidth();
        double nx1 = this.end.getX() / this.bounds.getWidth();
        if (renderer.getArcDirection() == 2) {
            alpha0 = Math.acos(nx0);
            alpha1 = Math.acos(nx1);
        } else {
            alpha0 = Math.acos(nx1);
            alpha1 = Math.acos(nx0);
        }
        return new Arc2D.Double(this.start.getX(), this.start.getY(), this.bounds.getWidth(), this.bounds.getHeight(), alpha0, alpha1 - alpha0, arcType);
    }
}

