/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFPanel;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.swing.ExtensionFileFilter;

public class EMFViewer
extends JFrame {
    private static String TITLE = "Freehep EMF Viewer";
    private static String LOAD_BUTTON_TITLE = "Open EMF";
    private static String ZOOMIN__BUTTON_TITLE = "Zoom in";
    private static String ZOOMOUT_BUTTON_TITLE = "Zoom out";
    private EMFPanel emfPanel = new EMFPanel();
    private JFileChooser fileChooser = new JFileChooser();

    public EMFViewer() {
        this.initGUI();
        this.setDefaultCloseOperation(3);
        this.setSize(500, 300);
    }

    private void initGUI() {
        this.setTitle(TITLE);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel mainPanel = new JPanel();
        this.getContentPane().add(mainPanel);
        mainPanel.setLayout(new BorderLayout(3, 3));
        mainPanel.add("Center", new JScrollPane(this.emfPanel));
        this.fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("emf", "Encapsulated Metafile"));
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 3, 3));
        mainPanel.add("South", buttonPanel);
        JButton zoomInButton = new JButton(ZOOMIN__BUTTON_TITLE);
        zoomInButton.addActionListener(new ZoomInAction());
        buttonPanel.add(zoomInButton);
        JButton zoomOutButton = new JButton(ZOOMOUT_BUTTON_TITLE);
        zoomOutButton.addActionListener(new ZoomOutAction());
        buttonPanel.add(zoomOutButton);
        JButton loadButton = new JButton(LOAD_BUTTON_TITLE);
        loadButton.addActionListener(new OpenFileAction());
        buttonPanel.add(loadButton);
    }

    public void show(File emfFile) {
        try {
            FileInputStream fis = new FileInputStream(emfFile);
            EMFInputStream emf = new EMFInputStream(new BufferedInputStream(fis));
            EMFRenderer renderer = new EMFRenderer(emf);
            this.emfPanel.setRenderer(renderer);
            this.setTitle(TITLE + " - " + emfFile.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    private class ZoomOutAction
    implements ActionListener {
        private ZoomOutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            EMFViewer.this.emfPanel.zoomOut();
        }
    }

    private class ZoomInAction
    implements ActionListener {
        private ZoomInAction() {
        }

        public void actionPerformed(ActionEvent e) {
            EMFViewer.this.emfPanel.zoomIn();
        }
    }

    private class OpenFileAction
    implements ActionListener {
        private OpenFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int result = EMFViewer.this.fileChooser.showOpenDialog(EMFViewer.this);
            if (result == 0) {
                EMFViewer.this.show(EMFViewer.this.fileChooser.getSelectedFile());
            }
        }
    }
}

