% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{lshift}
\alias{lshift}
\title{Take lag transformation of a series.}
\usage{
lshift(x, l)
}
\arguments{
\item{x}{a series to be lagged}

\item{l}{the number of lags}
}
\value{
the lagged series
}
\description{
Take lag transformation of a series.
}
\details{
\code{lshift} assumes that the series are ordered, that there is no missing data, and that the time intervals are even.
}
\examples{
x.var <- runif(50)
l.1.x.var <- lshift(x.var, 1)
l.2.x.var <- lshift(x.var, 2)
head(x.var)
head(l.1.x.var)
head(l.2.x.var)
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{utilities}
