% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_obj.R
\name{get_risk_obj}
\alias{get_risk_obj}
\title{Risk Set on an Equidistant Distant Grid}
\usage{
get_risk_obj(Y, by, max_T, id, is_for_discrete_model = T, n_threads = 1,
  min_chunk = 5000)
}
\arguments{
\item{Y}{vector of outcome variable returned from \code{\link{Surv}}.}

\item{by}{length of each bin.}

\item{max_T}{last observed time.}

\item{id}{vector with ids where entries match with outcomes \code{Y}.}

\item{is_for_discrete_model}{\code{TRUE} if the model outcome is discrete. For example, a logit model is discrete whereas what is is referred to as the exponential model in this package is a dynamic model.}

\item{n_threads}{set to a value greater than one to use \code{\link{mclapply}} to find the risk object.}

\item{min_chunk}{minimum chunk size of ids to use when parallel version is used.}
}
\value{
a list with the following elements
\item{risk_sets}{list of lists with one for each bin. Each of the sub lists have indices that corresponds to the entries of \code{Y} that are at risk in the bin.}
\item{min_start}{start time of the first bin.}
\item{I_len}{length of each bin.}
\item{d}{number of bins.}
\item{is_event_in}{indices for which bin an observation \code{Y} is an event. \code{-1} if the individual does not die in any of the bins.}
\item{is_for_discrete_model}{value of \code{is_for_discrete_model} argument.}
}
\description{
Get the risk set at each bin over an equidistant distant grid.
}
\examples{
# small toy example with time-varying covariates
dat <- data.frame(
 id     = c(1, 1, 2, 2),
 tstart = c(0, 4, 0, 2),
 tstop  = c(4, 6, 2, 4),
 event  = c(0, 1, 0, 0))

with(dat, get_risk_obj(Surv(tstart, tstop, event), by = 1, max_T = 6, id = id))

}
